/**
* Script: optionsstate.js
* Written by: Radnen
* Updated: 1/6/2011
**/

function OptionState(text, name) {
	if (!name) name = "OptionState";
	this.inherit = State;
	this.inherit(name);
	
	this.x = SW/2-240;
	this.y = SH/2-120;
	options = ["Edit Player Controls", "Star Quality", "Music Volume", "Sound Volume", "Screen Size"];
	this.sel = 0;
	
	this.onOkay = new Event(this);
	this.onCancel = new Event(this);
	
	var c_holder = new ControlHolder(0, 0, SW, SH);
	var panel = new Panel(c_holder, this.x, this.y, SW, SH);
	var items = new ListBox(panel, 12, 12, 242, 112);
	var restart = false;
	
	var starpanel = new Panel(panel, 266, 8, 160, 120);
	var starcheck = new CheckBox(starpanel, 8, 32, "High Quality");
	starcheck.checked = Genesis.starQuality;
	starcheck.onCheck = function() {
		Genesis.starQuality = starcheck.checked;
	}
	starpanel.controls.push(starcheck);
	
	var volumepanel = new Panel(panel, 266, 8, 160, 120);
	var volselector = new NumberSelector(volumepanel, 32, 32, 255, 5);
	volselector.onChange = function() {
		if (items.item.text == "Music Volume") Audio.max = volselector.value;
		else if (items.item.text == "Sound Volume") Audio.smax = volselector.value;
	}
	volumepanel.controls.push(volselector);
	
	var screenpanel = new Panel(panel, 266, 8, 160, 120);
	var sizedrop = new DropDown(screenpanel, 8, 32, 144);
	sizedrop.items = ["800x600", "1024x768", "1080x720", "1440x900", "1680x1050", "1920x1080"]; // draw from list!
	sizedrop.onSelect = function() {
		// apply change //
		restart = true;
	}
	screenpanel.controls.push(sizedrop);
	
	for (var i = 0; i < options.length; ++i) {
		items.addText(options[i], function() {
			if (items.item.text == "Star Quality") {
				panel.controls[1] = starpanel;
			}
			else if (items.item.text == "Music Volume") {
				volselector.value = Audio.max;
				panel.controls[1] = volumepanel;
			}
			else if (items.item.text == "Sound Volume") {
				volselector.value = Audio.smax;
				panel.controls[1] = volumepanel;
			}
			else if (items.item.text == "Screen Size") {
				panel.controls[1] = screenpanel;
			}
		});
	}
	
	this.okaybutton = new EasyButton("Okay", this.x+380, this.y+180);
	this.okaybutton.onClick.add(function(sender) {
		Genesis.saveOptions();
		sender.hide();
		sender.onOkay.execute();
	}, this);
	
	this.cancelbutton = new EasyButton("Cancel", this.x+50, this.y+180);
	this.cancelbutton.onClick.add(function(sender) {
		sender.hide();
		sender.onCancel.execute();
	}, this);

	this.render.add(function() {
		Rectangle(this.x, this.y, 480, 240, Colors.black);
		OutlinedRectangle(this.x, this.y, 480, 240, Colors.gray);
		OutlinedRectangle(this.x+266, this.y+8, 208, 152, Colors.gray);
		OutlinedRectangle(this.x+8, this.y+8, 250, 152, Colors.gray);
		
		this.okaybutton.draw();
		this.cancelbutton.draw();
		c_holder.draw();
		if (items.item != null) System.drawText(this.x+274, this.y+12, items.item.text+":");
		if (restart) System.drawText(this.x+8, this.y+216, "* Needs restart for changes to take effect.", Colors.red);
	});
	
	this.update.add(function() {
		this.okaybutton.update();
		this.cancelbutton.update();
		c_holder.update();
	});
	
	c_holder.controls.push(panel);
	panel.controls.push(items);
}